clear;
clc;
fullScriptPath = matlab.desktop.editor.getActiveFilename();
[folderPath, ~, ~] = fileparts(fullScriptPath);
% FILE1
%nomefile
file1 = 'C2_2025-05-06_16-30-55.txt';
% Define the names of the files you want to read
filename1 = fullfile(folderPath, file1);
% Importa i dati
data_import_1 = importdata(filename1,'\t');
% Visualizza i dati
data1=data_import_1.data(5:end,:);
disp(data_import_1);
% FILE2
%nomefile
file2 = 'DRONE_2025-05-06_16-30-55.txt';
% Define the names of the files you want to read
filename2 = fullfile(folderPath, file2);
% Importa i dati
data_import_2 = importdata(filename2,'\t');
% Visualizza i dati
data2=data_import_2.data(5:end,:);
disp(data_import_2);

% proiezione mercatore
x1=6371*(data1(:,3)-data1(1,3));
y1=6371*log(tan(pi/4+(data1(:,2)-data1(1,2))/2));


x2=6371*(data2(:,3)-data2(1,3));
y2=6371*log(tan(pi/4+(data2(:,2)-data2(1,2))/2));

%%
figure(1)
plot3(x1,y1,data1(:,4)*0.3048,'k', 'LineWidth', 1.5);
hold on
plot3(x2,y2,data2(:,4)*0.3048,'--k', 'LineWidth', 1.5)
hold off
grid on
xlabel('X');
ylabel('Y');
zlabel('Z');
pbaspect([1 1 0.75]) % Aspect ratio X:Y:Z
set(gcf, 'Position', [100, 100, 600, 600]) % [x, y, width, height]

figure(2)
plot(x1,data1(:,4)*0.3048,'k', 'LineWidth', 1.5)
hold on
plot(x2,data2(:,4)*0.3048,'--k', 'LineWidth', 1.5)
hold off
grid on
xlabel('X');
ylabel('Z');
pbaspect([1 1 1]) % Aspect ratio X:Y:Z
set(gcf, 'Position', [100, 100, 600, 600]) % [x, y, width, height]

figure(3)
plot(x1,y1,'k', 'LineWidth', 1.5)
hold on
plot(x2,y2,'--k', 'LineWidth', 1.5)
hold off
grid on
xlabel('X');
ylabel('Y');
pbaspect([1 1 1]) % Aspect ratio X:Y:Z
set(gcf, 'Position', [100, 100, 600, 600]) % [x, y, width, height]
%%
figure(4)
plot3(x1(1:3000),y1(1:3000),data1(1:3000,4)*0.3048,'k', 'LineWidth', 1.5);
hold on
plot3(x2(1:3000),y2(1:3000),data2(1:3000,4)*0.3048,'--k', 'LineWidth', 1.5)
hold off
grid on
xlabel('X');
ylabel('Y');
zlabel('Z');
pbaspect([1 1 0.75]) % Aspect ratio X:Y:Z
set(gcf, 'Position', [100, 100, 600, 600]) % [x, y, width, height]
%%
figure(5)
plot3(x1(3000:5000),y1(3000:5000),data1(3000:5000,4)*0.3048,'k', 'LineWidth', 1.5);
hold on
plot3(x2(3000:5000),y2(3000:5000),data2(3000:5000,4)*0.3048,'--k', 'LineWidth', 1.5)
hold off
grid on
xlabel('X');
ylabel('Y');
zlabel('Z');
pbaspect([1 1 0.75]) % Aspect ratio X:Y:Z
set(gcf, 'Position', [100, 100, 600, 600]) % [x, y, width, height]
zlim([800 1000])
%%
figure(6)
plot3(x1(5000:6000),y1(5000:6000),data1(5000:6000,4)*0.3048,'k', 'LineWidth', 1.5);
hold on
plot3(x2(5000:6000),y2(5000:6000),data2(5000:6000,4)*0.3048,'--k', 'LineWidth', 1.5)
hold off
grid on
xlabel('X');
ylabel('Y');
zlabel('Z');
pbaspect([1 1 0.75]) % Aspect ratio X:Y:Z
set(gcf, 'Position', [100, 100, 600, 600]) % [x, y, width, height]
zlim([800 1000])
%%
figure(8)
plot3(x1(6000:6600),y1(6000:6600),data1(6000:6600,4)*0.3048,'k', 'LineWidth', 1.5);
hold on
plot3(x2(6000:6600),y2(6000:6600),data2(6000:6600,4)*0.3048,'--k', 'LineWidth', 1.5)
hold off
grid on
xlabel('X');
ylabel('Y');
zlabel('Z');
pbaspect([1 1 0.75]) % Aspect ratio X:Y:Z
set(gcf, 'Position', [100, 100, 600, 600]) % [x, y, width, height]
zlim([800 1400])
%%
figure(9)
plot3(x1(6600:8000),y1(6600:8000),data1(6600:8000,4)*0.3048,'k', 'LineWidth', 1.5);
hold on
plot3(x2(6600:8000),y2(6600:8000),data2(6600:8000,4)*0.3048,'--k', 'LineWidth', 1.5)
hold off
grid on
xlabel('X');
ylabel('Y');
zlabel('Z');
pbaspect([1 1 0.75]) % Aspect ratio X:Y:Z
set(gcf, 'Position', [100, 100, 600, 600]) % [x, y, width, height]
